; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;

; ** 09-Jun-05 PanQ Solutions, Autodesk Pte. Created 
;    as sample post-process util
; ---------  W I R E LABEL . L S P  -----------------------------
; Post-process Wire from/to report. 
;
; This routine is called from AutoCAD Electrical's "User post" button on the
; Wire From/To report dialog display. Report data is passed to this
; routine in AutoLISP variable called "wd_rdata". This utility can
; then operate on this report data, reformat it into a new list of
; report data "rtrn" and then pass it back to AutoCAD Electrical's report dialog 
; through a call to (c:wd_rtrn_2wd rtrn) shown at the end of this file.
;
; -- Structure of the "wd_rdata" list of lists passed from AutoCAD Electrical:
;
; (list (list <wire label data>) (list <cable label data>) ... )
; where wire label data sublist consists of a list of the following:
; 0 = wire number
; 1 = CMP name of device connect with wire
; 2 = terminal PIN number for device connection
; 3 = INST of connecting device
; 4 = LOC connecting device
; 5 = drawing name which connecting device is existing
; 6 = mark of if wire is a "in cable" wire. T if wire is "in cable", otherwise NIL.
;
; where wire label data sublist consists of a list of the following:
; 0 = cable name
; 1 = string of FROM_CMPS names of device, each component name are seperated with comma
; 2 = INST of "from" device
; 3 = LOC of "from" device
; 4 = string of TO_CMPS names of device, each component name are seperated with comma
; 5 = INST of "to" device
; 6 = LOC of "to" device
; 7 = Cable Description 1
; 8 = Cable Description 2
; 9 = Cable Description 3
;10= drawing name which cable is existing

(defun _wd_post_main ( / rtrn dclnam dcl_id user_1 user_2 user_3 cancel xx wlay1
                         lay_map_lst data wd_make_dcl wd_nth_subst wirelst cablelst)

  ; -- internal subroutines
  ; --
  ; -- main routine --
  (setq rtrn nil)
  ; AutoCAD Electrical passes the report displayed data as a list of lists of lists in variable
  ; called wd_rdata. The first element of this list is the list of lists
  ; report data. The 2nd element is future (at this time).
  (setq wirelst '())
  (setq cablelst '())
  (if (AND wd_rdata (= 2 (length wd_rdata))) (setq wirelst (car wd_rdata) cablelst (cadr wd_rdata)))

  ; Create and reference a ".dcl" file, on-the-fly
  
  (setq user_1 "0")
  (setq user_2 "0")
  (setq user_3 "0")
  ; Look for dcl file of same name, open if found.
  (setq cancel nil)
  (if (setq dclnam (c:ace_find_file "wirelabel.dcl" 16)) ; 16=display error dialog if file not found
    (progn
      (setq dcl_id (load_dialog dclnam))                
      (if (new_dialog "main_select" dcl_id)
        (progn
          (set_tile "user1" user_1) ; set toggles per defaults above
          (set_tile "user2" user_2)
          (set_tile "user3" user_3)
          (action_tile "user1" "(setq user_1 $value)")
          (action_tile "user2" "(setq user_2 $value)")
          (action_tile "user3" "(setq user_3 $value)")
          (action_tile "cancel" "(setq cancel 1)")
          (start_dialog)
          (unload_dialog dcl_id)
  ) ) ) )

  (setq rtrn (list wirelst cablelst))

  (if (AND wd_rdata (not cancel))
    (progn ; user didn't cancel out of dialog, okay to continue
      (if (= user_1 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "1" "wirelabel.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
      (if (= user_2 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "2" "wirelabel.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
      (if (= user_3 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "3" "wirelabel.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
    )  
  )  
  (c:wd_rtrn_2wd rtrn) ; return post-processed list back to AutoCAD Electrical's report dialog
)
; -- the following AUTO-STARTS when this file is "loaded" from within AutoCAD Electrical (i.e.
;    user hits the "User post" button on a report display dialog)
(_wd_post_main) ; run the above program
(princ)
